@echo off
setlocal enabledelayedexpansion

REM 查询 5037 端口并获取对应的 PID
set "pids="
for /f "tokens=5 delims= " %%a in ('netstat -ano ^| findstr :5037') do (
    set pid=%%a
    REM 检查 PID 是否为空，防止没有找到匹配项时尝试杀死不存在的进程
    if not "!pid!"=="" (
        echo Process with PID !pid! is using port 5037.
        REM 避免重复添加相同的PID
        if "!pids!"=="!pids:*%%a=!" (
            set "pids=!pids! %%a"
            REM 强制杀掉该 PID 对应的进程
            taskkill /PID %%a /F
            if errorlevel 1 (
                echo Failed to kill process with PID %%a.
            ) else (
                echo Successfully killed process with PID %%a.
            )
        )
    )
)

endlocal & set pids=%pids%

REM 检查是否有任何进程被杀掉，如果有则等待几秒以确保进程完全终止
if not "%pids%"=="" (
    echo Waiting for processes to terminate...
    timeout /t 5 >nul
)

REM 执行 ADB 命令前，确保设备已连接并可访问
adb devices
if errorlevel 1 (
    echo ADB device not found or not accessible.
    exit /b 1
)

REM 推送文件、更改权限并重启设备
adb push UlanziDeckKey /data/UlanziDeckKey
if errorlevel 1 (
    echo Failed to push file to device.
    exit /b 1
)

adb shell chmod 777 /data/UlanziDeckKey
if errorlevel 1 (
    echo Failed to change file permissions on device.
    exit /b 1
)

adb reboot
if errorlevel 1 (
    echo Failed to reboot device.
    exit /b 1
)

echo All operations completed successfully.
pause